---
generated_at: 2026-02-03 10:05:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：2-Nodes Report

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **オプションカラム数「80以上」の正確性**：全カラムの厳密なカウントは設計書では省略

## 2) 参照した情報（Evidence一覧）

- E-01: `server/src/main/java/org/opensearch/rest/action/cat/RestNodesAction.java` 行91-657
- E-02: `server/src/main/java/org/opensearch/rest/action/cat/AbstractCatAction.java` 行59-110
- E-03: `docs/code-to-docs/帳票一覧/帳票一覧.csv` 行3
- E-04: `server/src/test/java/org/opensearch/rest/action/cat/RestNodesActionTests.java`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | エンドポイントは GET /_cat/nodes | E-01 行98 | ○ |
| C-02 | 3段階の非同期API呼び出し（State→Info→Stats） | E-01 行112-164 | ○ |
| C-03 | full_id パラメータでID表示を制御 | E-01 行123 | ○ |
| C-04 | local パラメータは非推奨 | E-01 行93-94, 行115-116 | ○ |
| C-05 | デフォルト表示カラム（ip, heap.percent, ram.percent, cpu, load等） | E-01 行172-210 | ○ |
| C-06 | NodesInfoRequest で JVM, OS, PROCESS, HTTP を取得 | E-01 行130-134 | ○ |
| C-07 | NodesStatsRequest で JVM, OS, FS, PROCESS, SCRIPT, indices を取得 | E-01 行142-149 | ○ |
| C-08 | disk.used の計算式 | E-01 行472 | ○ |
| C-09 | disk.used_percent の計算式 | E-01 行474-475 | ○ |
| C-10 | ロードアベレージの -1 チェック | E-01 行499-512 | ○ |
| C-11 | node.role はロール略称を結合 | E-01 行521-529 | ○ |
| C-12 | cluster_manager に master エイリアスあり | E-01 行209 | ○ |
| C-13 | file_desc.percent の計算 | E-01 行654-656 | ○ |
| C-14 | ノードごとにnullチェックして空欄表示 | E-01 行439-444 | ○ |
| C-15 | NodesInfoRequest.Metric で情報種別を指定 | E-01 行131-134 | ○ |
| C-16 | buildTable はfullId, req, state, info, stats の5引数 | E-01 行423-429 | ○ |
| C-17 | 帳票一覧での定義内容 | E-03 | ○ |
| C-18 | オプションカラム数が80以上 | **根拠なし（概算値）** | △ |

## 4) 不足情報（Unknown / Missing）
- オプションカラムの正確な総数はソースコードの addCell 呼び出し数をカウントすれば判明するが、設計書では概算値としている
  - 候補：RestNodesAction.java の getTableWithHeader() 内の addCell 呼び出し総数をカウント

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 処理フローとデータソースの記述はコードから正確に読み取れる
- 0: 低リスク - デフォルト表示カラムの定義はコードと一致

## 6) レビュアーチェックリスト（最小）
- [ ] デフォルト表示カラム（default:true）の一覧が正確か
- [ ] 3段階の非同期呼び出し順序が正しいか
- [ ] 計算式（disk.used, disk.used_percent, file_desc.percent）がコードと一致するか
